-- new script file

local attackST = {}
local mission = {}

function OnAfterSceneLoaded(self)
  self:AddTriggerTarget("attST")
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    
    if not self.loaded then
      self.attackCounter = 0
      self.baseCount = 100 * Citadels.GetPlayer(0):GetDifficultyCoef()
      self.active = false
    end    
    
    mission.enemy = Citadels.GetPlayer(4)
    self.attackPoint = Game:GetEntity('P3-thallSP-L1-0'):GetPosition()
  end
  
  if self.active then
    if self.attackCounter > 0 then 
      UpgradeWave(self) 
    end
    InitializeWave(self)
    GenerateWaveAI(self)
    self.attackCounter = self.attackCounter + 1
    self.active = false
  end  
end

function InitializeWave(self)
  attackST['unit_L_archer_L1'] = self.baseCount * 0.08
  attackST['unit_L_fman_L1'] = self.baseCount * 0.06
end

function UpgradeWave(self)
  self.baseCount = baseCount + 20
end

function GenerateWaveAI(self)
  for prefab,ammount in pairs(attackST) do
    mission.enemy:AttackGroupAdd(prefab, ammount)
  end
  --mission.enemy:AttackGroupSetModeToSpawn()
  mission.enemy:AttackGroupAllowedTargetIndex(0) --attack only at player index 0 - human player
  mission.enemy:AttackGroupAddWayPoints(self.attackPoint)
  mission.enemy:AttackGroupCommit(1, self:GetPosition(),20)
  mission.enemy:AttackGroupMaxWaitTimeForUnitsCreation(120)
end

function OnTrigger(self, source, target)
  if target == "attST" then
    self.active = true
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
    self.attackCounter = ar:Read()
    self.baseCount = ar:Read()
    self.active = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.attackCounter)
    ar:Write(self.baseCount)
    ar:Write(self.active)
  end
end
